using System;

namespace gov.va.med.vbecs.Common
{

	#region Header

	///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
	///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
	///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
	///<Developers>
	///	<Developer>Brian Tomlin</Developer>
	///</Developers>
	///<SiteName>Hines OIFO</SiteName>
	///<CreationDate>10/9/2003</CreationDate>
	///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
	///<summary></summary>

	#endregion

    //TODO: move to HL7 Open Library
	public class HL7DateFormat
	{
		private HL7DateFormat() {}

		///<Developers>
		///	<Developer>Brian Tomlin</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>6/9/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="4686"> 
		///		<ExpectedInput>4 char date</ExpectedInput>
		///		<ExpectedOutput>Date</ExpectedOutput>
		///	</Case>
		///
		///<Case type="0" testid ="4687"> 
		///		<ExpectedInput>6 char date</ExpectedInput>
		///		<ExpectedOutput>Date</ExpectedOutput>
		///	</Case>
		///
		///<Case type="0" testid ="4688"> 
		///		<ExpectedInput>8 char date</ExpectedInput>
		///		<ExpectedOutput>Date</ExpectedOutput>
		///	</Case>
		///
		///<Case type="0" testid ="4689"> 
		///		<ExpectedInput>12 char date</ExpectedInput>
		///		<ExpectedOutput>Date</ExpectedOutput>
		///	</Case>
		///
		///<Case type="0" testid ="4690"> 
		///		<ExpectedInput>14 char date</ExpectedInput>
		///		<ExpectedOutput>Date</ExpectedOutput>
		///	</Case>
		///
		///<Case type="0" testid ="4691"> 
		///		<ExpectedInput>17 char date</ExpectedInput>
		///		<ExpectedOutput>Date</ExpectedOutput>
		///	</Case>
		///
		///<Case type="0" testid ="4692"> 
		///		<ExpectedInput>19 char date</ExpectedInput>
		///		<ExpectedOutput>Date</ExpectedOutput>
		///	</Case>
		///
		///<Case type="0" testid ="4693"> 
		///		<ExpectedInput>valid char date</ExpectedInput>
		///		<ExpectedOutput>Date</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="610"> 
		///		<ExpectedInput>Invalid string length</ExpectedInput>
		///		<ExpectedOutput>IndexOutOfRangeException</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// ConvertHL7DateTime
		/// </summary>
		/// <param name="str"></param>
		/// <returns></returns>
		public static DateTime ConvertHL7DateTime(string str)
		{
			// Check the length and parse accordingly
			// HL7 Dates can be YYYY[MM[DD[HHMM[SS]]][-ZZZZ]
			// Year (4 chars),
			// Year/Month (6 chars),
			// Year/Month/Day (8 chars),
			// Year/Month/Day/Hour/Minutes (12 chars),
			// Year/Month/Day/Hour/Minutes/Seconds (14 chars),
			// Year/Month/Day/Hour/Minutes/TimeZone (17 chars),
			// Year/Month/Day/Hour/Minutes/Seconds/TimeZone (19 chars).
			// Maximum chars = 19.
			// Precision of ten thousandths of seconds is not supported.
			// Substring nodes:  YYYYMMDDHHMM S S - Z Z Z Z
			//                   012345678910
			if (str.Length > 19)
				throw new System.IndexOutOfRangeException("HL7 Date/Time string out of range");
			
			DateTime dt;
			int year, month, day, hour, minute, second;
			switch (str.Length)
			{
				case 4:
					year = Convert.ToInt32(str.Substring(0,4));
					dt = new DateTime(year, 1, 1);		
					return dt;
					
				case 6:
					//**
					year = Convert.ToInt32(str.Substring(0,4));
					month = Convert.ToInt32(str.Substring(4,2));
					//**Day of 0 will cause an exception
                    day = 0;
                    dt = new DateTime(year, month, day);
                   
					return dt;

				case 8:
					year = Convert.ToInt32(str.Substring(0,4));
					month = CheckMonth(str.Substring(4,2));
					day = CheckDay(str.Substring(6,2));
					dt = new DateTime(year, month, day);
					return dt;

				case 12:
					year = Convert.ToInt32(str.Substring(0,4));
					month = CheckMonth(str.Substring(4,2));
					day = CheckDay(str.Substring(6,2));
					hour = Convert.ToInt32(str.Substring(8,2));
					minute = Convert.ToInt32(str.Substring(10,2));
					second = 0;
					dt = new DateTime(year, month, day, hour, minute, second);
					return dt;

				case 14:
					year = Convert.ToInt32(str.Substring(0,4));
					month = CheckMonth(str.Substring(4,2));
					day = CheckDay(str.Substring(6,2));
					hour = Convert.ToInt32(str.Substring(8,2));
					minute = Convert.ToInt32(str.Substring(10,2));
					second = CheckSeconds(str.Substring(12,2));
					dt = new DateTime(year, month, day, hour, minute, second);
					return dt;

				case 17:
					year = Convert.ToInt32(str.Substring(0,4));
					month = CheckMonth(str.Substring(4,2));
					day = CheckDay(str.Substring(6,2));
					hour = Convert.ToInt32(str.Substring(8,2));
					minute = Convert.ToInt32(str.Substring(10,2));
					second = 0;
					dt = new DateTime(year, month, day, hour, minute, second);
					return dt;

				case 19:
					// TimeZone not implemented
					year = Convert.ToInt32(str.Substring(0,4));
					month = CheckMonth(str.Substring(4,2));
					day = CheckDay(str.Substring(6,2));
					hour = Convert.ToInt32(str.Substring(8,2));
					minute = Convert.ToInt32(str.Substring(10,2));
					second = CheckSeconds(str.Substring(12,2));
					dt = new DateTime(year, month, day, hour, minute, second);
					return dt;

				default:
					// Return YYYYMMDD  
					//**Assumes input string is 8+ chars long
					if( str.Length >= 8 )
					{
						year = Convert.ToInt32(str.Substring(0,4));
						month = CheckMonth(str.Substring(4,2));
						day = CheckDay(str.Substring(6,2));
						dt = new DateTime(year, month, day);
						return dt;
					}
					else
						return DateTime.MinValue;
			}
		}

	    ///<Developers>
	    ///	<Developer>Russell Stephenson</Developer>
	    ///</Developers>
	    ///<SiteName>Hines OIFO</SiteName>
	    ///<CreationDate>6/9/2004</CreationDate>
	    ///<TestCases>
	    ///</TestCases>
	    ///<Update></Update>
	    ///<ArchivePlan></ArchivePlan>
	    ///<Interfaces></Interfaces>
	    ///
	    /// <summary>
	    /// ConvertHL7DateTime
	    /// Defect#: 229650 Added to support long datetime fields in HL7 messages.
	    ///  </summary>
	    /// <param name="str"></param>
	    /// <returns></returns>
	    public static DateTime ConvertHL7LongDateTime(string str)
	    {
	        // Check the length and parse accordingly
	        // HL7 Dates can be YYYY[MM[DD[HHMM[SS]]][-ZZZZ]
	        // Year (4 chars),
	        // Year/Month (6 chars),
	        // Year/Month/Day (8 chars),
	        // Year/Month/Day/Hour/Minutes (12 chars),
	        // Year/Month/Day/Hour/Minutes/Seconds (14 chars),
	        // Year/Month/Day/Hour/Minutes/TimeZone (17 chars),
	        // Year/Month/Day/Hour/Minutes/Seconds/TimeZone (19 chars).
	        // Year/Month/Day/Hour/Minutes/Seconds/Milliseconds/TimeZone (24 chars).
	        // Maximum chars = 24.
	        // Substring nodes:  YYYYMMDDHHMM S S - Z Z Z Z
	        //                   012345678910
	        if (str.Length > 24)
	            throw new System.IndexOutOfRangeException("HL7 Date/Time string out of range");

	        if (str.Length <= 19)
	            return ConvertHL7DateTime(str);

	        DateTime dt;
	        int year, month, day, hour, minute, second, millisecond;
	        switch (str.Length)
	        {
	            case 24:
	                // TimeZone not implemented
	                year = Convert.ToInt32(str.Substring(0, 4));
	                month = CheckMonth(str.Substring(4, 2));
	                day = CheckDay(str.Substring(6, 2));
	                hour = Convert.ToInt32(str.Substring(8, 2));
	                minute = Convert.ToInt32(str.Substring(10, 2));
	                second = CheckSeconds(str.Substring(12, 2));
	                millisecond = Convert.ToInt32(str.Substring(15, 4));
	                millisecond = millisecond/10;
	                dt = new DateTime(year, month, day, hour, minute, second, millisecond);
	                return dt;

	            default:
                    return DateTime.MinValue;
	        }
	    }

	    ///<Developers>
		///	<Developer>Brian Tomlin</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>9/12/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="8207"> 
		///		<ExpectedInput>Valid current HL7 Date/Time</ExpectedInput>
		///		<ExpectedOutput>valid current UTC Date/Time</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="8208"> 
		///		<ExpectedInput>Invalid string length</ExpectedInput>
		///		<ExpectedOutput>IndexOutOfRangeException</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="8221"> 
		///		<ExpectedInput>Null hl7Date string value</ExpectedInput>
		///		<ExpectedOutput>ArgumentNullException</ExpectedOutput>
		///	</Case>
		///
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Converts HL7 DateTime to UTC
		/// </summary>
		/// <param name="hl7Date">HL7 DateTime string value.</param>
		/// <returns>HL7 DateTime value converted to <see cref="DateTime"/> in UTC.</returns>
		public static DateTime ConvertHL7DateTimeToUniversalDateTime(string hl7Date)
		{
			if( hl7Date == null )
				throw( new ArgumentNullException( "hl7Date" ) );

			return ConvertHL7DateTime(hl7Date).ToUniversalTime();
		}

		///<Developers>
		///	<Developer>Brian Tomlin</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>9/12/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="8209"> 
		///		<ExpectedInput>Valid current System.DateTime</ExpectedInput>
		///		<ExpectedOutput>Valid matching HL7 DateTime </ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="8210"> 
		///		<ExpectedInput>Negative test is not valid for this method.</ExpectedInput>
		///		<ExpectedOutput>N/A</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Converts HL7 to DateTime
		/// </summary>
		/// <param name="date"><see cref="DateTime"/> to be converted to an HL7 format string.</param>
		/// <returns>HL7 format string.</returns>
		public static string ConvertDateTimeToHL7(DateTime date)
		{
			return date.ToString("yyyyMMdd");
		}

        /// <summary>
        /// Defect 210141 / CR 3211 Modified this method to be public
        /// </summary>
        /// <param name="month"></param>
        /// <returns></returns>
		public static int CheckMonth(string month)
		{
			if (month == "00")
			{
				return 01;
			}
			else
			{
				return Convert.ToInt32(month);
			}
		}

        /// <summary>
        /// Defect 210141 / CR 3211 Modified this method to be public
        /// </summary>
        /// <param name="day"></param>
        /// <returns></returns>
        public static int CheckDay(string day)
		{
			if (day == "00")
			{
				return 01;
			}
			else
			{
				return Convert.ToInt32(day);
			}
		}

        /// <summary>
        /// Defect 210141 / CR 3211 Modified this method to be public
        /// </summary>
        /// <param name="seconds"></param>
        /// <returns></returns>
        public static int CheckSeconds(string seconds)
		{
			if (Convert.ToInt32(seconds) > 59)
			{
				return 59;
			}
			else
			{
				return Convert.ToInt32(seconds);
			}
		}

	}
}
